package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSSystemExtensionType implements Enum {

    @JsonProperty("driverExtensionsAllowed")
    DRIVER_EXTENSIONS_ALLOWED("driverExtensionsAllowed", "1"),

    @JsonProperty("networkExtensionsAllowed")
    NETWORK_EXTENSIONS_ALLOWED("networkExtensionsAllowed", "2"),

    @JsonProperty("endpointSecurityExtensionsAllowed")
    ENDPOINT_SECURITY_EXTENSIONS_ALLOWED("endpointSecurityExtensionsAllowed", "4");

    private final String name;
    private final String value;

    private MacOSSystemExtensionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
