package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSGatekeeperAppSources implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("macAppStore")
    MAC_APP_STORE("macAppStore", "1"),

    @JsonProperty("macAppStoreAndIdentifiedDevelopers")
    MAC_APP_STORE_AND_IDENTIFIED_DEVELOPERS("macAppStoreAndIdentifiedDevelopers", "2"),

    @JsonProperty("anywhere")
    ANYWHERE("anywhere", "3");

    private final String name;
    private final String value;

    private MacOSGatekeeperAppSources(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
