package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSFileVaultRecoveryKeyTypes implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("institutionalRecoveryKey")
    INSTITUTIONAL_RECOVERY_KEY("institutionalRecoveryKey", "1"),

    @JsonProperty("personalRecoveryKey")
    PERSONAL_RECOVERY_KEY("personalRecoveryKey", "2");

    private final String name;
    private final String value;

    private MacOSFileVaultRecoveryKeyTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
