package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MacOSContentCachingType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("userContentOnly")
    USER_CONTENT_ONLY("userContentOnly", "1"),

    @JsonProperty("sharedContentOnly")
    SHARED_CONTENT_ONLY("sharedContentOnly", "2");

    private final String name;
    private final String value;

    private MacOSContentCachingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
