package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LocalSecurityOptionsAdministratorElevationPromptBehaviorType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("elevateWithoutPrompting")
    ELEVATE_WITHOUT_PROMPTING("elevateWithoutPrompting", "1"),

    @JsonProperty("promptForCredentialsOnTheSecureDesktop")
    PROMPT_FOR_CREDENTIALS_ON_THE_SECURE_DESKTOP("promptForCredentialsOnTheSecureDesktop", "2"),

    @JsonProperty("promptForConsentOnTheSecureDesktop")
    PROMPT_FOR_CONSENT_ON_THE_SECURE_DESKTOP("promptForConsentOnTheSecureDesktop", "3"),

    @JsonProperty("promptForCredentials")
    PROMPT_FOR_CREDENTIALS("promptForCredentials", "4"),

    @JsonProperty("promptForConsent")
    PROMPT_FOR_CONSENT("promptForConsent", "5"),

    @JsonProperty("promptForConsentForNonWindowsBinaries")
    PROMPT_FOR_CONSENT_FOR_NON_WINDOWS_BINARIES("promptForConsentForNonWindowsBinaries", "6");

    private final String name;
    private final String value;

    private LocalSecurityOptionsAdministratorElevationPromptBehaviorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
