package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum LanManagerAuthenticationLevel implements Enum {

    @JsonProperty("lmAndNltm")
    LM_AND_NLTM("lmAndNltm", "0"),

    @JsonProperty("lmNtlmAndNtlmV2")
    LM_NTLM_AND_NTLM_V2("lmNtlmAndNtlmV2", "1"),

    @JsonProperty("lmAndNtlmOnly")
    LM_AND_NTLM_ONLY("lmAndNtlmOnly", "2"),

    @JsonProperty("lmAndNtlmV2")
    LM_AND_NTLM_V2("lmAndNtlmV2", "3"),

    @JsonProperty("lmNtlmV2AndNotLm")
    LM_NTLM_V2AND_NOT_LM("lmNtlmV2AndNotLm", "4"),

    @JsonProperty("lmNtlmV2AndNotLmOrNtm")
    LM_NTLM_V2AND_NOT_LM_OR_NTM("lmNtlmV2AndNotLmOrNtm", "5");

    private final String name;
    private final String value;

    private LanManagerAuthenticationLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
