package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum KeyUsages implements Enum {

    @JsonProperty("keyEncipherment")
    KEY_ENCIPHERMENT("keyEncipherment", "1"),

    @JsonProperty("digitalSignature")
    DIGITAL_SIGNATURE("digitalSignature", "2");

    private final String name;
    private final String value;

    private KeyUsages(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
