package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IosKioskModeAppType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("appStoreApp")
    APP_STORE_APP("appStoreApp", "1"),

    @JsonProperty("managedApp")
    MANAGED_APP("managedApp", "2"),

    @JsonProperty("builtInApp")
    BUILT_IN_APP("builtInApp", "3");

    private final String name;
    private final String value;

    private IosKioskModeAppType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
