package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum InstallState implements Enum {

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "0"),

    @JsonProperty("installed")
    INSTALLED("installed", "1"),

    @JsonProperty("failed")
    FAILED("failed", "2"),

    @JsonProperty("notInstalled")
    NOT_INSTALLED("notInstalled", "3"),

    @JsonProperty("uninstallFailed")
    UNINSTALL_FAILED("uninstallFailed", "4"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "5");

    private final String name;
    private final String value;

    private InstallState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
