package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IncomingTokenType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("primaryRefreshToken")
    PRIMARY_REFRESH_TOKEN("primaryRefreshToken", "1"),

    @JsonProperty("saml11")
    SAML11("saml11", "2"),

    @JsonProperty("saml20")
    SAML20("saml20", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private IncomingTokenType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
