package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ImportedWindowsAutopilotDeviceIdentityUploadStatus implements Enum {

    @JsonProperty("noUpload")
    NO_UPLOAD("noUpload", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("complete")
    COMPLETE("complete", "2"),

    @JsonProperty("error")
    ERROR("error", "3");

    private final String name;
    private final String value;

    private ImportedWindowsAutopilotDeviceIdentityUploadStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
