package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IdentityUserFlowAttributeType implements Enum {

    @JsonProperty("builtIn")
    BUILT_IN("builtIn", "1"),

    @JsonProperty("custom")
    CUSTOM("custom", "2"),

    @JsonProperty("required")
    REQUIRED("required", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private IdentityUserFlowAttributeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
