package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IdentityUserFlowAttributeDataType implements Enum {

    @JsonProperty("string")
    STRING("string", "1"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "2"),

    @JsonProperty("int64")
    INT64("int64", "3"),

    @JsonProperty("stringCollection")
    STRING_COLLECTION("stringCollection", "4"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private IdentityUserFlowAttributeDataType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
