package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum GroupAccessType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("private")
    PRIVATE("private", "1"),

    @JsonProperty("secret")
    SECRET("secret", "2"),

    @JsonProperty("public")
    PUBLIC("public", "3");

    private final String name;
    private final String value;

    private GroupAccessType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
