package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FirewallPreSharedKeyEncodingMethodType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("none")
    NONE("none", "1"),

    @JsonProperty("utF8")
    UT_F8("utF8", "2");

    private final String name;
    private final String value;

    private FirewallPreSharedKeyEncodingMethodType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
