package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum FederatedIdpMfaBehavior implements Enum {

    @JsonProperty("acceptIfMfaDoneByFederatedIdp")
    ACCEPT_IF_MFA_DONE_BY_FEDERATED_IDP("acceptIfMfaDoneByFederatedIdp", "0"),

    @JsonProperty("enforceMfaByFederatedIdp")
    ENFORCE_MFA_BY_FEDERATED_IDP("enforceMfaByFederatedIdp", "1"),

    @JsonProperty("rejectMfaByFederatedIdp")
    REJECT_MFA_BY_FEDERATED_IDP("rejectMfaByFederatedIdp", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private FederatedIdpMfaBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
