package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ExternalAudienceScope implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("contactsOnly")
    CONTACTS_ONLY("contactsOnly", "1"),

    @JsonProperty("all")
    ALL("all", "2");

    private final String name;
    private final String value;

    private ExternalAudienceScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
