package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ExpirationPatternType implements Enum {

    @JsonProperty("notSpecified")
    NOT_SPECIFIED("notSpecified", "0"),

    @JsonProperty("noExpiration")
    NO_EXPIRATION("noExpiration", "1"),

    @JsonProperty("afterDateTime")
    AFTER_DATE_TIME("afterDateTime", "2"),

    @JsonProperty("afterDuration")
    AFTER_DURATION("afterDuration", "3");

    private final String name;
    private final String value;

    private ExpirationPatternType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
