package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ErrorCode implements Enum {

    @JsonProperty("noError")
    NO_ERROR("noError", "0"),

    @JsonProperty("unauthorized")
    UNAUTHORIZED("unauthorized", "1"),

    @JsonProperty("notFound")
    NOT_FOUND("notFound", "2"),

    @JsonProperty("deleted")
    DELETED("deleted", "3");

    private final String name;
    private final String value;

    private ErrorCode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
