package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EntrySyncOperation implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Add")
    ADD("Add", "1"),

    @JsonProperty("Delete")
    DELETE("Delete", "2"),

    @JsonProperty("Update")
    UPDATE("Update", "3");

    private final String name;
    private final String value;

    private EntrySyncOperation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
