package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EntryExportStatus implements Enum {

    @JsonProperty("Noop")
    NOOP("Noop", "0"),

    @JsonProperty("Success")
    SUCCESS("Success", "1"),

    @JsonProperty("RetryableError")
    RETRYABLE_ERROR("RetryableError", "2"),

    @JsonProperty("PermanentError")
    PERMANENT_ERROR("PermanentError", "3"),

    @JsonProperty("Error")
    ERROR("Error", "4");

    private final String name;
    private final String value;

    private EntryExportStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
