package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EntityType implements Enum {

    @JsonProperty("event")
    EVENT("event", "0"),

    @JsonProperty("message")
    MESSAGE("message", "1"),

    @JsonProperty("driveItem")
    DRIVE_ITEM("driveItem", "2"),

    @JsonProperty("externalItem")
    EXTERNAL_ITEM("externalItem", "4"),

    @JsonProperty("site")
    SITE("site", "5"),

    @JsonProperty("list")
    LIST("list", "6"),

    @JsonProperty("listItem")
    LIST_ITEM("listItem", "7"),

    @JsonProperty("drive")
    DRIVE("drive", "8"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "9");

    private final String name;
    private final String value;

    private EntityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
