package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EnrollmentState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("enrolled")
    ENROLLED("enrolled", "1"),

    @JsonProperty("pendingReset")
    PENDING_RESET("pendingReset", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("notContacted")
    NOT_CONTACTED("notContacted", "4"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "5");

    private final String name;
    private final String value;

    private EnrollmentState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
