package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EnrollmentRestrictionPlatformType implements Enum {

    @JsonProperty("allPlatforms")
    ALL_PLATFORMS("allPlatforms", "0"),

    @JsonProperty("ios")
    IOS("ios", "1"),

    @JsonProperty("windows")
    WINDOWS("windows", "2"),

    @JsonProperty("windowsPhone")
    WINDOWS_PHONE("windowsPhone", "3"),

    @JsonProperty("android")
    ANDROID("android", "4"),

    @JsonProperty("androidForWork")
    ANDROID_FOR_WORK("androidForWork", "5"),

    @JsonProperty("mac")
    MAC("mac", "7");

    private final String name;
    private final String value;

    private EnrollmentRestrictionPlatformType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
