package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointSecurityConfigurationApplicablePlatform implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "1"),

    @JsonProperty("windows10AndLater")
    WINDOWS10AND_LATER("windows10AndLater", "2"),

    @JsonProperty("windows10AndWindowsServer")
    WINDOWS10AND_WINDOWS_SERVER("windows10AndWindowsServer", "3");

    private final String name;
    private final String value;

    private EndpointSecurityConfigurationApplicablePlatform(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
