package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EncryptionReadinessState implements Enum {

    @JsonProperty("notReady")
    NOT_READY("notReady", "0"),

    @JsonProperty("ready")
    READY("ready", "1");

    private final String name;
    private final String value;

    private EncryptionReadinessState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
