package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EmailType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("work")
    WORK("work", "1"),

    @JsonProperty("personal")
    PERSONAL("personal", "2"),

    @JsonProperty("main")
    MAIN("main", "3"),

    @JsonProperty("other")
    OTHER("other", "4");

    private final String name;
    private final String value;

    private EmailType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
