package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EmailSyncDuration implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("oneDay")
    ONE_DAY("oneDay", "1"),

    @JsonProperty("threeDays")
    THREE_DAYS("threeDays", "2"),

    @JsonProperty("oneWeek")
    ONE_WEEK("oneWeek", "3"),

    @JsonProperty("twoWeeks")
    TWO_WEEKS("twoWeeks", "4"),

    @JsonProperty("oneMonth")
    ONE_MONTH("oneMonth", "5"),

    @JsonProperty("unlimited")
    UNLIMITED("unlimited", "6");

    private final String name;
    private final String value;

    private EmailSyncDuration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
