package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EligibilityFilteringEnabledEntities implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("swapRequest")
    SWAP_REQUEST("swapRequest", "1"),

    @JsonProperty("offerShiftRequest")
    OFFER_SHIFT_REQUEST("offerShiftRequest", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private EligibilityFilteringEnabledEntities(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
