package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationSynchronizationStatus implements Enum {

    @JsonProperty("paused")
    PAUSED("paused", "0"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "1"),

    @JsonProperty("success")
    SUCCESS("success", "2"),

    @JsonProperty("error")
    ERROR("error", "3"),

    @JsonProperty("validationError")
    VALIDATION_ERROR("validationError", "4"),

    @JsonProperty("quarantined")
    QUARANTINED("quarantined", "5"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6"),

    @JsonProperty("extracting")
    EXTRACTING("extracting", "7"),

    @JsonProperty("validating")
    VALIDATING("validating", "8");

    private final String name;
    private final String value;

    private EducationSynchronizationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
