package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationSubmissionStatus implements Enum {

    @JsonProperty("working")
    WORKING("working", "0"),

    @JsonProperty("submitted")
    SUBMITTED("submitted", "1"),

    @JsonProperty("released")
    RELEASED("released", "2"),

    @JsonProperty("returned")
    RETURNED("returned", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4"),

    @JsonProperty("reassigned")
    REASSIGNED("reassigned", "5");

    private final String name;
    private final String value;

    private EducationSubmissionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
