package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationExternalSource implements Enum {

    @JsonProperty("sis")
    SIS("sis", "0"),

    @JsonProperty("manual")
    MANUAL("manual", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2"),

    @JsonProperty("lms")
    LMS("lms", "3");

    private final String name;
    private final String value;

    private EducationExternalSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
