package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationAssignmentStatus implements Enum {

    @JsonProperty("draft")
    DRAFT("draft", "0"),

    @JsonProperty("published")
    PUBLISHED("published", "1"),

    @JsonProperty("assigned")
    ASSIGNED("assigned", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private EducationAssignmentStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
