package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EducationAddToCalendarOptions implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("studentsAndPublisher")
    STUDENTS_AND_PUBLISHER("studentsAndPublisher", "1"),

    @JsonProperty("studentsAndTeamOwners")
    STUDENTS_AND_TEAM_OWNERS("studentsAndTeamOwners", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3"),

    @JsonProperty("studentsOnly")
    STUDENTS_ONLY("studentsOnly", "4");

    private final String name;
    private final String value;

    private EducationAddToCalendarOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
