package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EditionUpgradeLicenseType implements Enum {

    @JsonProperty("productKey")
    PRODUCT_KEY("productKey", "0"),

    @JsonProperty("licenseFile")
    LICENSE_FILE("licenseFile", "1"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "2");

    private final String name;
    private final String value;

    private EditionUpgradeLicenseType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
