package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EdgeKioskModeRestrictionType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("digitalSignage")
    DIGITAL_SIGNAGE("digitalSignage", "1"),

    @JsonProperty("normalMode")
    NORMAL_MODE("normalMode", "2"),

    @JsonProperty("publicBrowsingSingleApp")
    PUBLIC_BROWSING_SINGLE_APP("publicBrowsingSingleApp", "3"),

    @JsonProperty("publicBrowsingMultiApp")
    PUBLIC_BROWSING_MULTI_APP("publicBrowsingMultiApp", "4");

    private final String name;
    private final String value;

    private EdgeKioskModeRestrictionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
