package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EdgeCookiePolicy implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("allow")
    ALLOW("allow", "1"),

    @JsonProperty("blockThirdParty")
    BLOCK_THIRD_PARTY("blockThirdParty", "2"),

    @JsonProperty("blockAll")
    BLOCK_ALL("blockAll", "3");

    private final String name;
    private final String value;

    private EdgeCookiePolicy(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
