package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EapFastConfiguration implements Enum {

    @JsonProperty("noProtectedAccessCredential")
    NO_PROTECTED_ACCESS_CREDENTIAL("noProtectedAccessCredential", "0"),

    @JsonProperty("useProtectedAccessCredential")
    USE_PROTECTED_ACCESS_CREDENTIAL("useProtectedAccessCredential", "1"),

    @JsonProperty("useProtectedAccessCredentialAndProvision")
    USE_PROTECTED_ACCESS_CREDENTIAL_AND_PROVISION("useProtectedAccessCredentialAndProvision", "2"),

    @JsonProperty("useProtectedAccessCredentialAndProvisionAnonymously")
    USE_PROTECTED_ACCESS_CREDENTIAL_AND_PROVISION_ANONYMOUSLY("useProtectedAccessCredentialAndProvisionAnonymously", "3");

    private final String name;
    private final String value;

    private EapFastConfiguration(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
