package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DriveItemSourceApplication implements Enum {

    @JsonProperty("teams")
    TEAMS("teams", "0"),

    @JsonProperty("yammer")
    YAMMER("yammer", "1"),

    @JsonProperty("sharePoint")
    SHARE_POINT("sharePoint", "2"),

    @JsonProperty("oneDrive")
    ONE_DRIVE("oneDrive", "3"),

    @JsonProperty("stream")
    STREAM("stream", "4"),

    @JsonProperty("powerPoint")
    POWER_POINT("powerPoint", "5"),

    @JsonProperty("office")
    OFFICE("office", "6"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private DriveItemSourceApplication(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
