package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DiagnosticDataSubmissionMode implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("none")
    NONE("none", "1"),

    @JsonProperty("basic")
    BASIC("basic", "2"),

    @JsonProperty("enhanced")
    ENHANCED("enhanced", "3"),

    @JsonProperty("full")
    FULL("full", "4");

    private final String name;
    private final String value;

    private DiagnosticDataSubmissionMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
