package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManangementIntentValueType implements Enum {

    @JsonProperty("integer")
    INTEGER("integer", "0"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "1"),

    @JsonProperty("string")
    STRING("string", "2"),

    @JsonProperty("complex")
    COMPLEX("complex", "3"),

    @JsonProperty("collection")
    COLLECTION("collection", "4"),

    @JsonProperty("abstractComplex")
    ABSTRACT_COMPLEX("abstractComplex", "5");

    private final String name;
    private final String value;

    private DeviceManangementIntentValueType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
