package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementTemplateSubtype implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("firewall")
    FIREWALL("firewall", "1"),

    @JsonProperty("diskEncryption")
    DISK_ENCRYPTION("diskEncryption", "2"),

    @JsonProperty("attackSurfaceReduction")
    ATTACK_SURFACE_REDUCTION("attackSurfaceReduction", "3"),

    @JsonProperty("endpointDetectionReponse")
    ENDPOINT_DETECTION_REPONSE("endpointDetectionReponse", "4"),

    @JsonProperty("accountProtection")
    ACCOUNT_PROTECTION("accountProtection", "5"),

    @JsonProperty("antivirus")
    ANTIVIRUS("antivirus", "6"),

    @JsonProperty("firewallSharedAppList")
    FIREWALL_SHARED_APP_LIST("firewallSharedAppList", "7"),

    @JsonProperty("firewallSharedIpList")
    FIREWALL_SHARED_IP_LIST("firewallSharedIpList", "8"),

    @JsonProperty("firewallSharedPortlist")
    FIREWALL_SHARED_PORTLIST("firewallSharedPortlist", "9");

    private final String name;
    private final String value;

    private DeviceManagementTemplateSubtype(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
