package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementPartnerTenantState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("unavailable")
    UNAVAILABLE("unavailable", "1"),

    @JsonProperty("enabled")
    ENABLED("enabled", "2"),

    @JsonProperty("terminated")
    TERMINATED("terminated", "3"),

    @JsonProperty("rejected")
    REJECTED("rejected", "4"),

    @JsonProperty("unresponsive")
    UNRESPONSIVE("unresponsive", "5");

    private final String name;
    private final String value;

    private DeviceManagementPartnerTenantState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
