package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementExportJobLocalizationType implements Enum {

    @JsonProperty("localizedValuesAsAdditionalColumn")
    LOCALIZED_VALUES_AS_ADDITIONAL_COLUMN("localizedValuesAsAdditionalColumn", "0"),

    @JsonProperty("replaceLocalizableValues")
    REPLACE_LOCALIZABLE_VALUES("replaceLocalizableValues", "1");

    private final String name;
    private final String value;

    private DeviceManagementExportJobLocalizationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
