package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementExchangeConnectorStatus implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("connectionPending")
    CONNECTION_PENDING("connectionPending", "1"),

    @JsonProperty("connected")
    CONNECTED("connected", "2"),

    @JsonProperty("disconnected")
    DISCONNECTED("disconnected", "3");

    private final String name;
    private final String value;

    private DeviceManagementExchangeConnectorStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
