package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationStringFormat implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("email")
    EMAIL("email", "1"),

    @JsonProperty("guid")
    GUID("guid", "2"),

    @JsonProperty("ip")
    IP("ip", "3"),

    @JsonProperty("base64")
    BASE64("base64", "4"),

    @JsonProperty("url")
    URL("url", "5"),

    @JsonProperty("version")
    VERSION("version", "6"),

    @JsonProperty("xml")
    XML("xml", "7"),

    @JsonProperty("date")
    DATE("date", "8"),

    @JsonProperty("time")
    TIME("time", "9"),

    @JsonProperty("binary")
    BINARY("binary", "10"),

    @JsonProperty("regEx")
    REG_EX("regEx", "11"),

    @JsonProperty("json")
    JSON("json", "12"),

    @JsonProperty("dateTime")
    DATE_TIME("dateTime", "13"),

    @JsonProperty("surfaceHub")
    SURFACE_HUB("surfaceHub", "14");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationStringFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
