package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationSettingAccessTypes implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("add")
    ADD("add", "1"),

    @JsonProperty("copy")
    COPY("copy", "2"),

    @JsonProperty("delete")
    DELETE("delete", "4"),

    @JsonProperty("get")
    GET("get", "8"),

    @JsonProperty("replace")
    REPLACE("replace", "16"),

    @JsonProperty("execute")
    EXECUTE("execute", "32");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationSettingAccessTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
