package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementConfigurationAzureAdTrustType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("azureAdJoined")
    AZURE_AD_JOINED("azureAdJoined", "1"),

    @JsonProperty("addWorkAccount")
    ADD_WORK_ACCOUNT("addWorkAccount", "2"),

    @JsonProperty("mdmOnly")
    MDM_ONLY("mdmOnly", "4");

    private final String name;
    private final String value;

    private DeviceManagementConfigurationAzureAdTrustType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
