package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceManagementAutopilotPolicyComplianceStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("compliant")
    COMPLIANT("compliant", "1"),

    @JsonProperty("installed")
    INSTALLED("installed", "2"),

    @JsonProperty("notCompliant")
    NOT_COMPLIANT("notCompliant", "3"),

    @JsonProperty("notInstalled")
    NOT_INSTALLED("notInstalled", "4"),

    @JsonProperty("error")
    ERROR("error", "5");

    private final String name;
    private final String value;

    private DeviceManagementAutopilotPolicyComplianceStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
