package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeviceGuardVirtualizationBasedSecurityState implements Enum {

    @JsonProperty("running")
    RUNNING("running", "0"),

    @JsonProperty("rebootRequired")
    REBOOT_REQUIRED("rebootRequired", "1"),

    @JsonProperty("require64BitArchitecture")
    REQUIRE64BIT_ARCHITECTURE("require64BitArchitecture", "2"),

    @JsonProperty("notLicensed")
    NOT_LICENSED("notLicensed", "3"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "4"),

    @JsonProperty("doesNotMeetHardwareRequirements")
    DOES_NOT_MEET_HARDWARE_REQUIREMENTS("doesNotMeetHardwareRequirements", "5"),

    @JsonProperty("other")
    OTHER("other", "42");

    private final String name;
    private final String value;

    private DeviceGuardVirtualizationBasedSecurityState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
